package ru.yandex.travel.api.endpoints.trips.req_rsp;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.infrastucture.ParamName;

@Data
@NoArgsConstructor
@ApiModel(value = "Запрос следующих поездок для страницы Мои Поездки")
public class GetMoreTripsReqV1 {
    @ParamName("userGeoId")
    @ApiParam(name = "userGeoId", value = "Гео-id региона пользователя")
    @NotNull
    private int userGeoId = 10000;

    @ParamName("limit")
    @ApiParam(name = "limit", value = "Количество поездок")
    @NotNull
    private int limit = 3;

    @ParamName("continuationToken")
    @ApiParam(name = "continuationToken", value = "Токен для определения следующей страницы поездок")
    @NotNull
    private String continuationToken;
}
