package ru.yandex.travel.api.endpoints.trips.req_rsp;

import java.util.List;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.infrastucture.ParamName;

@Data
@NoArgsConstructor
@ApiModel(value = "Асинхронный запрос блоков поездки для страницы Моя Поездка")
public class GetTripAsyncBlocksReqV1 {
    @ParamName("tripId")
    @ApiParam(name = "tripId", value = "id поездки")
    @NotNull
    private String tripId;

    @ParamName("blockTypes")
    @ApiParam(name = "blockTypes", value = "типы загружаемых асинхронных блоков")
    @NotNull
    private List<String> blockTypes;

}
