package ru.yandex.travel.api.endpoints.trust_callback;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.api.services.orders.OrchestratorClientFactory;
import ru.yandex.travel.commons.concurrent.FutureUtils;
import ru.yandex.travel.orders.proto.TPaymentStatusChangedReq;

@Service
@Slf4j
@RequiredArgsConstructor
public class TrustCallbackImpl {

    private final OrchestratorClientFactory orchestratorClientFactory;

    public CompletableFuture<Void> basketStatusChanged(Map<String, String[]> params) {
        var reqBuilder = TPaymentStatusChangedReq.newBuilder();
        params.forEach((k, v) -> {
            if (v.length == 1) {
                reqBuilder.putAttributes(k, v[0]);
            } else {
                throw new IllegalArgumentException("Parameter " + k + "has multiple values: " + Arrays.toString(v));
            }
        });

        return FutureUtils.buildCompletableFuture(orchestratorClientFactory.createOrderNoAuthFutureStub()
                .paymentStatusChangedCallback(reqBuilder.build()))
                .thenApply(rsp -> null);
    }
}
