package ru.yandex.travel.api.endpoints.workflow_management;

import java.util.concurrent.CompletableFuture;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.api.endpoints.workflow_management.req_rsp.PauseWorkflowReqV1;
import ru.yandex.travel.api.endpoints.workflow_management.req_rsp.PauseWorkflowRspV1;
import ru.yandex.travel.api.endpoints.workflow_management.req_rsp.ResumeWorkflowReqV1;
import ru.yandex.travel.api.endpoints.workflow_management.req_rsp.ResumeWorkflowRspV1;
import ru.yandex.travel.api.services.workflow_management.WorkflowManagementClientFactory;
import ru.yandex.travel.commons.concurrent.FutureUtils;
import ru.yandex.travel.workflow.management.proto.TPauseWorkflowReq;
import ru.yandex.travel.workflow.management.proto.TResumeWorkflowReq;

@Service
@RequiredArgsConstructor
@Slf4j
public class WorkflowManagementImpl {

    private final WorkflowManagementClientFactory clientFactory;

    public CompletableFuture<PauseWorkflowRspV1> pauseWorkflow(PauseWorkflowReqV1 rq) {
        TPauseWorkflowReq grpcRq = TPauseWorkflowReq.newBuilder()
                .setWorkflowId(rq.toString())
                .build();
        return FutureUtils.buildCompletableFuture(
                clientFactory.createWorkflowManagementFutureStub().pauseWorkflow(grpcRq)
        ).thenApply(ign -> new PauseWorkflowRspV1());
    }

    public CompletableFuture<ResumeWorkflowRspV1> resumeWorkflow(ResumeWorkflowReqV1 rq) {
        TResumeWorkflowReq grpcRq = TResumeWorkflowReq.newBuilder()
                .setWorkflowId(rq.toString())
                .build();
        return FutureUtils.buildCompletableFuture(
                clientFactory.createWorkflowManagementFutureStub().resumeWorkflow(grpcRq)
        ).thenApply(ign -> new ResumeWorkflowRspV1());
    }

}
