package ru.yandex.travel.api.endpoints.yandex_plus;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

import ru.yandex.travel.api.endpoints.yandex_plus.req_rsp.GetUserYandexPlusInfoReqV1;
import ru.yandex.travel.api.endpoints.yandex_plus.req_rsp.GetUserYandexPlusInfoRspV1;
import ru.yandex.travel.api.infrastucture.BindFromQuery;
import ru.yandex.travel.api.infrastucture.ResponseProcessor;
import ru.yandex.travel.api.services.promo.YandexPlusService;
import ru.yandex.travel.commons.http.CommonHttpHeaders;

@RestController
@RequestMapping(value = "/api/common")
@RequiredArgsConstructor
@Slf4j
public class YandexPlusController {
    private final ResponseProcessor responseProcessor;
    private final YandexPlusService yandexPlusImpl;

    @RequestMapping(value = "/v1/get_user_yandex_plus_info", method = RequestMethod.GET, produces = "application/json")
    public DeferredResult<GetUserYandexPlusInfoRspV1> getUserYandexPlusInfo(@Validated @BindFromQuery GetUserYandexPlusInfoReqV1 req) {
        return responseProcessor.replyWithFuture("GetUserYandexPlusInfoV1", () -> yandexPlusImpl.getUserYandexPlusInfo(req, CommonHttpHeaders.get()));
    }
}
