package ru.yandex.travel.api.exceptions;

import lombok.Getter;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

import ru.yandex.travel.hotels.common.token.TravelToken;

public class ExpiredTravelTokenException extends RuntimeException {
    @Getter
    private final TravelToken travelToken;

    public ExpiredTravelTokenException(String message, TravelToken travelToken) {
        super(message);
        this.travelToken = travelToken;
    }

    public ResponseEntity<TokenResponse404> getResponseEntity() {
        return ResponseEntity.status(HttpStatus.NOT_FOUND).body(new TokenResponse404(travelToken, getMessage()));
    }

    @Getter
    public static class TokenResponse404 {
        private final String error = "Not Found";
        private final String message;
        private final int Status = 404;
        private final TravelToken token;

        public TokenResponse404(TravelToken token, String message) {
            this.token = token;
            this.message = message;
        }
    }
}
