package ru.yandex.travel.api.exceptions;

import java.util.Map;

import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

import ru.yandex.travel.commons.health.UnhealthyServiceException;

@ControllerAdvice
public class GlobalExceptionHandler {
    @ExceptionHandler({UnhealthyServiceException.class})
    public ResponseEntity<Map<String, String>> handleUnhealthyUsageErrors(UnhealthyServiceException ex) {
        return ResponseEntity.status(HttpStatus.SERVICE_UNAVAILABLE).body(Map.of("Error", ex.getMessage()));
    }

    @ExceptionHandler(TravelApiBadRequestException.class)
    @ResponseStatus(HttpStatus.BAD_REQUEST)
    public ResponseEntity<String> handleTravelApiBadRequestException(TravelApiBadRequestException e) {
        return ResponseEntity.badRequest().contentType(MediaType.TEXT_PLAIN).body(e.getMessage());
    }

    @ExceptionHandler(MaxUploadSizeExceededException.class)
    @ResponseStatus(HttpStatus.BAD_REQUEST)
    public ResponseEntity<String> handleMaxUploadException(MaxUploadSizeExceededException e) {
        return ResponseEntity.badRequest().contentType(MediaType.TEXT_PLAIN).body(e.getMessage());
    }
}
