package ru.yandex.travel.api.exceptions;

import java.util.Map;

import com.google.common.collect.ImmutableMap;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import lombok.Getter;
import lombok.Setter;
import org.springframework.http.HttpStatus;

@Getter
@Setter
public class GrpcError {
    private final static Map<Status.Code, HttpStatus> GRPC_TO_HTTP_MAP = new ImmutableMap.Builder<Status.Code,
            HttpStatus>()
            .put(Status.Code.NOT_FOUND, HttpStatus.NOT_FOUND)
            .put(Status.Code.INVALID_ARGUMENT, HttpStatus.BAD_REQUEST)
            .put(Status.Code.ALREADY_EXISTS, HttpStatus.CONFLICT)
            .put(Status.Code.UNAUTHENTICATED, HttpStatus.UNAUTHORIZED)
            .put(Status.Code.PERMISSION_DENIED, HttpStatus.FORBIDDEN)
            .put(Status.Code.ABORTED, HttpStatus.CONFLICT)
            .put(Status.Code.RESOURCE_EXHAUSTED, HttpStatus.TOO_MANY_REQUESTS)
            // TODO (mbobrov, tivelkov): map it 400 http status code
            .put(Status.Code.FAILED_PRECONDITION, HttpStatus.CONFLICT)
            .build();


    public int getStatus() {
        return status;
    }

    private int status;
    private String error;
    private String message;

    private GrpcError(int status, String error, String message) {
        this.status = status;
        this.error = error;
        this.message = message;
    }

    public static GrpcError fromGrpcStatusRuntimeException(StatusRuntimeException ex) {
        HttpStatus status = GRPC_TO_HTTP_MAP.getOrDefault(ex.getStatus().getCode(), HttpStatus.INTERNAL_SERVER_ERROR);
        return new GrpcError(status.value(), ex.getStatus().getCode().name(), ex.getStatus().getDescription());
    }
}
