package ru.yandex.travel.api.exceptions;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value = HttpStatus.BAD_REQUEST, reason = "Invalid Travel Token")
public class InvalidTravelTokenException extends RuntimeException {
    public InvalidTravelTokenException(String message, Throwable cause) {
        super(message, cause);
    }

    public InvalidTravelTokenException(String message) {
        super(message);
    }
}
