package ru.yandex.travel.api.exceptions;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value = HttpStatus.CONFLICT, reason = "Order Info Expired")
public class OrderInfoExpiredException extends RuntimeException {
    public OrderInfoExpiredException(String message, Throwable cause) {
        super(message, cause);
    }

    public OrderInfoExpiredException(String message) {
        super(message);
    }

    public OrderInfoExpiredException() {
    }
}
