package ru.yandex.travel.api.health.common;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.services.portal_recipes.PortalRecipesService;

@Component
@RequiredArgsConstructor
@ConditionalOnEnabledHealthIndicator("portal-recipes-service")
public class PortalRecipesHealthIndicator implements HealthIndicator {

    private final PortalRecipesService portalRecipesService;

    @Override
    public Health health() {
        if (portalRecipesService.isReady()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }
}
