package ru.yandex.travel.api.health.hotels;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.services.hotels.hotel_images.HotelImagesService;

@Component
@RequiredArgsConstructor
@ConditionalOnEnabledHealthIndicator("hotel-images")
public class HotelImagesHealthIndicator implements HealthIndicator {
    private final HotelImagesService hotelImagesService;

    @Override
    public Health health() {
        if (hotelImagesService.isReady()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }
}
