package ru.yandex.travel.api.health.hotels;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.services.hotels.slug.HotelSlugService;

@Component
@RequiredArgsConstructor
@ConditionalOnEnabledHealthIndicator("hotel-slug")
public class HotelSlugHealthIndicator implements HealthIndicator {
    private final HotelSlugService hotelSlugService;

    @Override
    public Health health() {
        if (hotelSlugService.isReady()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }
}
