package ru.yandex.travel.api.health.hotels;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.services.hotels.legacy.LegacyHotelInfoProvider;

@Component
@RequiredArgsConstructor
@ConditionalOnEnabledHealthIndicator("legacy-hotel")
public class LegacyHotelHealthIndicator implements HealthIndicator {
    private final LegacyHotelInfoProvider legacyHotelInfoProvider;

    @Override
    public Health health() {
        if (legacyHotelInfoProvider.isReady()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }
}
