package ru.yandex.travel.api.health.hotels;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.services.hotels.min_prices.MinMaxPricesService;

@Component
@RequiredArgsConstructor
@ConditionalOnEnabledHealthIndicator("mean-prices")
public class MinPricesServiceHealthIndicator implements HealthIndicator {

    // TODO: Is this the best option for health indicator?

    private final MinMaxPricesService minPricesService;

    @Override
    public Health health() {
        if (minPricesService.isReady()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }
}
