package ru.yandex.travel.api.health.hotels;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

import ru.yandex.travel.hotels.common.PartnerConfigService;

@Component
@RequiredArgsConstructor
@ConditionalOnEnabledHealthIndicator("hotels-partner-config")
public class PartnerConfigHealthIndicator implements HealthIndicator {
    private final PartnerConfigService parnterConfigService;

    @Override
    public Health health() {
        if (parnterConfigService.isReady()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }
}
