package ru.yandex.travel.api.health.hotels;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.services.hotels.region_images.RegionImagesService;

@Component
@RequiredArgsConstructor
@ConditionalOnEnabledHealthIndicator("region-images")
public class RegionImagesHealthIndicator implements HealthIndicator {
    private final RegionImagesService regionImagesService;

    @Override
    public Health health() {
        if (regionImagesService.isReady()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }
}
