package ru.yandex.travel.api.health.hotels;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.services.hotels.region_name.RegionNameService;

@Component
@RequiredArgsConstructor
@ConditionalOnEnabledHealthIndicator("region-name")
public class RegionNameHealthIndicator implements HealthIndicator {

    private final RegionNameService regionNameService;

    @Override
    public Health health() {
        if (regionNameService.isReady()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }
}
