package ru.yandex.travel.api.health.hotels;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.services.hotels.static_pages.RegionPagesStorage;


@Component
@RequiredArgsConstructor
@ConditionalOnEnabledHealthIndicator("city-static-pages")
public class RegionPagesStorageHealthIndicator implements HealthIndicator {
    private final RegionPagesStorage regionPagesStorage;

    @Override
    public Health health() {
        if (regionPagesStorage.isReady()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }
}
