package ru.yandex.travel.api.health.hotels;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.services.hotels.slug.RegionSlugService;

@Component
@RequiredArgsConstructor
@ConditionalOnEnabledHealthIndicator("region-slug")
public class RegionSlugHealthIndicator implements HealthIndicator {
    // TODO: Is this the best option for health indicator?

    private final RegionSlugService regionSlugService;

    @Override
    public Health health() {
        if (regionSlugService.isReady()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }
}
