package ru.yandex.travel.api.health.hotels;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.services.hotels.serp_popular_destinations.SerpPopularDestinationsService;

@Component
@RequiredArgsConstructor
@ConditionalOnEnabledHealthIndicator("serp-popular-destinations")
public class SerpPopularDestinationsHealthIndicator implements HealthIndicator {
    private final SerpPopularDestinationsService popularDestinationsService;

    @Override
    public Health health() {
        if (popularDestinationsService.isReady()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }
}
