package ru.yandex.travel.api.infrastucture;

import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;

import ru.yandex.travel.commons.proto.ProtoUtils;
import ru.yandex.travel.commons.proto.TJson;

public class JsonUtils {
    private static final List<String> personalDataFields = List.of(
            "phone", "email", "phone_number", "customer_email", "customer_phone",
            "first_name", "middle_name", "last_name", "patronymic",
            "birthday", "date_of_birth",
            "document_valid_till", "document_number",
            "blank_url"
    );

    public static JsonNode removePersonalData(TJson node) {
        return removePersonalData(ProtoUtils.fromTJson(node));
    }

    public static JsonNode removePersonalData(JsonNode node) {
        if (node.isObject()) {
            var fields = node.fields();
            while (fields.hasNext()) {
                var entry = fields.next();
                JsonNode entryNode = entry.getValue();
                if (entryNode.isObject() || entryNode.isArray()) {
                    removePersonalData(entryNode);
                } else {
                    if (personalDataFields.contains(entry.getKey())) {
                        entry.setValue(new TextNode("***"));
                    }
                }
            }
        } else if (node.isArray()) {
            node.elements().forEachRemaining(JsonUtils::removePersonalData);
        }
        return node;
    }
}
