package ru.yandex.travel.api.infrastucture;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;

import io.micrometer.core.instrument.Tag;

import ru.yandex.travel.api.config.common.MeterConfiguration;
import ru.yandex.travel.commons.metrics.TravelTag;

public class MetricUtils {
    public static void addRequestMetricTag(HttpServletRequest httpServletRequest, String key, String value, boolean transparent) {
        if (httpServletRequest.getAttribute(MeterConfiguration.ADDITIONAL_TAGS_ATTR_NAME) == null) {
            httpServletRequest.setAttribute(MeterConfiguration.ADDITIONAL_TAGS_ATTR_NAME, new ArrayList<Tag>());
        }
        ((ArrayList<Tag>)httpServletRequest.getAttribute(MeterConfiguration.ADDITIONAL_TAGS_ATTR_NAME)).add(new TravelTag(key, value, transparent));
    }
}
