package ru.yandex.travel.api.infrastucture;

import java.util.List;
import java.util.Map;

import javax.servlet.ServletRequest;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.web.servlet.mvc.method.annotation.ExtendedServletRequestDataBinder;

/**
 * ServletRequestDataBinder which supports fields renaming using {@link ParamName}
 *
 */
public class ParamNameDataBinder extends ExtendedServletRequestDataBinder {

    private Map<String, String> renameMapping;

    public ParamNameDataBinder(Object target, String objectName) {
        super(target, objectName);
    }

    public void setRenameMapping(Map<String, String> mapping) {
        this.renameMapping = mapping;
    }

    @Override
    protected void addBindValues(MutablePropertyValues mpvs, ServletRequest request) {
        super.addBindValues(mpvs, request);
        List<PropertyValue> props = mpvs.getPropertyValueList();
        for (int idx = 0; idx < props.size(); ++idx) {
            PropertyValue pv = props.get(idx);
            String name = pv.getName();
            if (name.endsWith("[]")) {
                name = name.substring(0, name.length() - 2);
            }
            if (renameMapping != null) {
                name = renameMapping.getOrDefault(name, name);
            }
            if (!name.equals(pv.getName())) {
                props.set(idx, new PropertyValue(name, pv.getValue()));
            }
        }
    }
}
