package ru.yandex.travel.api.infrastucture;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufJsonLogger {
    private final Logger logger;
    private final Logger jsonLogger;
    private final JsonFormat.Printer printer = JsonFormat.printer().preservingProtoFieldNames().omittingInsignificantWhitespace();

    public ProtobufJsonLogger(String logName) {
        logger = LoggerFactory.getLogger(ProtobufJsonLogger.class + "/" + logName);
        jsonLogger = LoggerFactory.getLogger(logName);
    }

    public void log(Message message) {
        try {
            jsonLogger.info(printer.print(message));
        } catch (InvalidProtocolBufferException e) {
            logger.error("Unable to print to log", e);
        }
    }
}
