package ru.yandex.travel.api.infrastucture;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

@Documented
@Constraint(validatedBy = RequiredWhenOtherHasValueValidator.class)
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface RequiredWhenOtherHasValue {
    String field();

    String otherField();

    String[] otherFieldValues();

    String message();

    Class<? extends Payload>[] payload() default {};

    Class<?>[] groups() default {};

    @Target({ElementType.TYPE})
    @Retention(RetentionPolicy.RUNTIME)
    @interface List {
        RequiredWhenOtherHasValue[] value();
    }
}
