package ru.yandex.travel.api.infrastucture;

import java.util.Set;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import org.springframework.beans.BeanWrapperImpl;

public class RequiredWhenOtherHasValueValidator implements ConstraintValidator<RequiredWhenOtherHasValue, Object> {
    private String field;
    private String otherField;
    private Set<String> otherValues;


    @Override
    public void initialize(RequiredWhenOtherHasValue constraintAnnotation) {
        this.field = constraintAnnotation.field();
        this.otherField = constraintAnnotation.otherField();
        this.otherValues = Set.of(constraintAnnotation.otherFieldValues());
    }

    @Override
    public boolean isValid(Object value, ConstraintValidatorContext context) {
        var o = new BeanWrapperImpl(value);
        Object other = o.getPropertyValue(otherField);
        if (other != null) {
            String actualOtherVal = other.toString();
            if (otherValues.contains(actualOtherVal)) {
                return o.getPropertyValue(field) != null;
            }
        }
        return true;
    }
}
