package ru.yandex.travel.api.infrastucture;

import javax.annotation.Nullable;

import com.google.common.base.Preconditions;

import ru.yandex.travel.api.exceptions.TravelApiBadRequestException;

public class TravelPreconditions {
    public static void checkRequestArgument(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new TravelApiBadRequestException(String.valueOf(errorMessage));
        }
    }

    public static void checkRequestArgument(
            boolean expression,
            @Nullable String errorMessageTemplate,
            @Nullable Object... errorMessageArgs) {

        try {
            Preconditions.checkArgument(expression, errorMessageTemplate, errorMessageArgs);
        } catch (IllegalArgumentException e) {
            throw new TravelApiBadRequestException(e.getMessage());
        }
    }
}
