package ru.yandex.travel.api.infrastucture.shutdown;

import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;
import org.springframework.stereotype.Component;

@WebEndpoint(id = "shutdown")
@Component
public class ShutdownEndpoint {

    private final ShutdownManager shutdownManager;

    public ShutdownEndpoint(ShutdownManager shutdownManager) {
        this.shutdownManager = shutdownManager;
    }

    @WriteOperation
    public void shutdown() {
        shutdownManager.initShutdown();
    }
}
