package ru.yandex.travel.api.models.admin;

import java.time.Instant;
import java.util.List;

import lombok.Builder;
import lombok.Data;

import ru.yandex.travel.orders.admin.proto.EPartnerType;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderState;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderType;
import ru.yandex.travel.orders.commons.proto.EOrderType;

@Data
@Builder
public class AdminFilterValues {
    @Data
    @Builder
    public static class CurrentFilterValues {
        private String orderIdFilter;
        private String prettyIdFilter;
        private String providerIdFilter;
        private String emailFilter;
        private String phoneFilter;
        private Instant createdAtFromFilter;
        private Instant createdAtToFilter;
        private EOrderType orderTypeFilter;
        private EDisplayOrderState orderStateFilter;
        private EPartnerType partnerFilter;
        private String purchaseTokenFilter;
        private String cardMaskFilter;
        private String rrnFilter;
        private String passengerNamesFilter;
        private String ticketNumberFilter;
        private String yandexUidFilter;
        private String carrierFilter;
        private String referralPartnerIdFilter;
    }

    private CurrentFilterValues currentValues;
    private List<EOrderType> orderTypeValues;
    private List<EDisplayOrderType> displayOrderTypeValues;
    private List<EDisplayOrderState> orderStateValues;
    private List<EPartnerType> partnerValues;
}
