package ru.yandex.travel.api.models.admin;

import java.time.Instant;
import java.util.List;

import lombok.Builder;
import lombok.Data;
import org.javamoney.moneta.Money;

import ru.yandex.travel.bus.model.BusBenefitType;
import ru.yandex.travel.bus.model.BusLegalEntity;
import ru.yandex.travel.bus.model.BusPartner;
import ru.yandex.travel.bus.model.BusPointInfo;

@Data
@Builder
public class BusRideInfo {
    private String rideId;
    private int supplierId;
    private BusPartner busPartner;
    private BusLegalEntity supplier;
    private String carrierCode;
    private BusLegalEntity carrier;

    private Instant departureTime;
    private Instant arrivalTime;
    private String departureTimeZone;
    private String arrivalTimeZone;
    private long duration;
    private BusPointInfo pointFrom;
    private BusPointInfo pointTo;
    private BusPointInfo titlePointFrom;
    private BusPointInfo titlePointTo;

    private Money price;
    private Money fee;
    private Money yandexFee;

    private Integer freeSeats;
    private Integer ticketLimit;
    private String bus;
    private String routeName;
    private String routeNumber;

    private List<BusBenefitType> benefits;
    private boolean canPayOffline;
    private boolean bookOnly;
    private boolean onlineRefund;
    private String refundConditions;
}
