package ru.yandex.travel.api.models.admin;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Builder;
import lombok.Data;

import ru.yandex.travel.hotels.common.refunds.RefundType;

@Data
@Builder
public class CancellationPenalty {
    private Instant startsAt;
    private Instant endsAt;
    private Type type;
    @JsonSerialize(using = RoundingDecimalSerializer.class)
    private BigDecimal amount;
    private String currency;

    public enum Type {
        NO_PENALTY("no_penalty"),
        SOME_PENALTY("some_penalty"),
        FULL_PRICE("full_price");

        private String value;

        Type(String value) {
            this.value = value;
        }

        public static CancellationPenalty.Type fromValue(String text) {
            for (CancellationPenalty.Type b : CancellationPenalty.Type.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }

        public static CancellationPenalty.Type fromRefundType(RefundType type) {
            switch (type) {
                case FULLY_REFUNDABLE:
                    return NO_PENALTY;
                case REFUNDABLE_WITH_PENALTY:
                    return SOME_PENALTY;
                case NON_REFUNDABLE:
                    return FULL_PRICE;
                default:
                    throw new IllegalArgumentException();
            }
        }
    }

    public static class RoundingDecimalSerializer extends JsonSerializer<BigDecimal> {
        @Override
        public void serialize(BigDecimal value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.setScale(2, BigDecimal.ROUND_HALF_UP).toString());
        }
    }
}
