package ru.yandex.travel.api.models.admin;

import java.time.Instant;
import java.util.List;

import lombok.Data;

import ru.yandex.travel.api.models.admin.promo.AdminPromoCampaigns;
import ru.yandex.travel.orders.admin.proto.EPartnerType;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderState;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderType;
import ru.yandex.travel.orders.commons.proto.EOrderType;

@Data
public class Order {
    private String id;
    private String yandexOrderId;
    private String url;
    private String adminActionToken;
    private EDisplayOrderState status;
    private EOrderType orderType;
    private EDisplayOrderType displayOrderType;
    private List<EPartnerType> partners;
    private Instant createdAt;
    private Instant updatedAt;
    private Instant expiresAt;
    private Instant servicedAt;
    private OwnerInfo owner;
    private List<HotelOrderItemInfo> hotelOrderItems;
    private List<AviaOrderItemInfo> aviaOrderItems;
    private List<TrainOrderItemInfo> trainOrderItems;
    private List<DefaultOrderItemInfo> defaultOrderItems;
    private List<BusOrderItemInfo> busOrderItems;
    private List<PaymentAttemptInfo> paymentInfo;
    private PaymentScheduleInfo paymentSchedule;
    private List<PendingInvoiceInfo> pendingInvoices;

    private List<AuthorizedUser> authorizedUsers;
    private List<String> starTrekTicketIds;
    private List<OrderRefundInfo> orderRefunds;
    private List<Voucher> vouchers;
    private boolean userActionScheduled;
    private boolean broken;
    private AdminPromoCampaigns promoCampaigns;
    private AdminOrderPriceInfo orderPriceInfo;
    private AdminOrderGeneratedPromoCodesInfo generatedPromoCodesInfo;

    private boolean isPostPayEligible;
    private boolean isPostPaid;

    private String workflowId;
    private String workflowType;

    private OrderFlags flags;
}
