package ru.yandex.travel.api.models.admin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = OrderItemPayloadInfo.OrderItemPayloadInfoBuilder.class)
public class OrderItemPayloadInfo {
    private String orderItemId;
    private Integer version;
    private JsonNode payload;

    @JsonPOJOBuilder(withPrefix = "")
    public static class OrderItemPayloadInfoBuilder {
    }
}
