package ru.yandex.travel.api.models.admin;

import java.time.Instant;
import java.util.UUID;

import lombok.Builder;
import lombok.Data;

@Data
@Builder
public class OrderLogRecord {
    private UUID ownerUuid;
    private Instant timestamp;
    private String messageId;
    private String level;
    private String logger;
    private String message;
    private String context;
    private String hostName;

    public String toString() {
        return hostName + ": " +
                timestamp.toString() + " " +
                level + " " +
                messageId + " " +
                ownerUuid + " --- " +
                logger + ": " +
                message;
    }
}
