package ru.yandex.travel.api.models.admin;

import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.hotels.proto.EPansionType;

public enum PansionType {
    ALL_INCLUSIVE("all_inclusive", EPansionType.PT_AI),
    BED_AND_BREAKFAST("bed_and_breakfast", EPansionType.PT_BB),
    FULL_BOARD("full_board", EPansionType.PT_FB),
    HALF_BOARD("half_board", EPansionType.PT_HB),
    ROOM_ONLY("room_only", EPansionType.PT_RO),
    ULTRA_ALL_INCLUSIVE("ultra_all_inclusive", EPansionType.PT_UAI),
    LIGHT_ALL_INCLUSIVE("light_all_inclusive", EPansionType.PT_LAI),
    DINNER_ONLY("dinner_only", EPansionType.PT_BD);

    private final String value;
    private final EPansionType protoValue;

    public final static EnumIndex<EPansionType, PansionType> BY_PROTO =
            EnumIndex.create(PansionType.class, eValue -> eValue.protoValue);

    PansionType(String value, EPansionType protoValue) {
        this.value = value;
        this.protoValue = protoValue;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }
}
