package ru.yandex.travel.api.models.admin;

import java.time.Instant;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.javamoney.moneta.Money;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class PaymentAttemptInfo {
    private String trustPaymentId;
    private Instant startedAt;
    private Instant cancelledAt;
    private Instant paidAt;
    private Instant refundedAt;
    private String status;
    private String paymentRespCode;
    private String paymentRespDesc;
    private String rrn;
    private String cardNumber;
    private String scroogeUrl;
    private String paymentUrl;
    private Money originalPrice;
    private Money currentPrice;
    private List<InvoiceItemInfo> invoiceItems;
    private List<TrustRefundInfo> trustRefunds;
    private List<ReceiptItem> receipts;
    private String approvalCode;
}
