package ru.yandex.travel.api.models.admin;

import java.time.Instant;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.javamoney.moneta.Money;

import ru.yandex.travel.orders.workflow.payments.proto.EPaymentState;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PendingInvoiceInfo {
    private String id;
    private EPaymentState state;
    private Money totalAmount;
    private Money pendingAmount;
    private Instant createdAt;
    private Instant paidAt;
    private String workflowId;
    private List<PaymentAttemptInfo> paymentAttempts;
}
