package ru.yandex.travel.api.models.admin;

import java.time.Instant;
import java.util.List;

import lombok.Data;
import org.javamoney.moneta.Money;

import ru.yandex.travel.orders.admin.proto.EPartnerType;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderState;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderType;
import ru.yandex.travel.orders.commons.proto.EOrderType;
import ru.yandex.travel.orders.workflow.hotels.proto.EHotelOrderState;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotOrderState;

@Data
public class TravelAdminOrderListItem {
    private String orderId;
    private String prettyId;

    private EOrderType orderType;
    private EDisplayOrderType displayOrderType;
    private List<EPartnerType> partners;
    private Instant createdAt;
    private Instant updatedAt;
    private Instant expiresAt;
    private EDisplayOrderState displayOrderState;
    private String orderItemState;
    private String invoiceState;

    private EHotelOrderState hotelOrderState;
    private EAeroflotOrderState aeroflotOrderState;

    private String workflowId;
    private boolean broken;

    private String clientsNames;
    private Money priceInfo;
    private List<BriefHotelOrderItemInfo> hotelInfo;
    private List<BriefAviaOrderItemInfo> aviaInfo;
    private List<BriefTrainOrderItemInfo> trainInfo;
    private List<BriefBusOrderItemInfo> busInfo;
    private String ownerEmail;
    private String ownerPhone;
    private boolean deferred;
}
