package ru.yandex.travel.api.models.admin;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum TrustRefundType {
    TRUST_REFUND("trust_refund"), TRUST_RESIZE("trust_resize");

    private String value;

    TrustRefundType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static TrustRefundType fromString(String value) {
        for (TrustRefundType candidate : TrustRefundType.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown trust refund type %s", value));
    }
}
