package ru.yandex.travel.api.models.admin.promo;

import java.time.Instant;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.travel.commons.proto.ProtoUtils;
import ru.yandex.travel.hotels.common.orders.promo.YandexPlusApplication;
import ru.yandex.travel.orders.admin.proto.TYandexPlusInfo;
import ru.yandex.travel.orders.workflow.plus.proto.EYandexPlusTopupState;
import ru.yandex.travel.orders.workflow.plus.proto.TTopupInfo;
import ru.yandex.travel.orders.workflow.plus.proto.TWithdrawalInfo;

@Getter
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class AdminYandexPlus {
    private YandexPlusApplication.Mode mode;
    private TopupInfo topupInfo;
    private WithdrawalInfo withdrawalInfo;

    public static AdminYandexPlus fromProto(TYandexPlusInfo proto) {
        var plus = new AdminYandexPlus();

        switch (proto.getMode()) {
            case YPM_TOPUP:
                plus.mode = YandexPlusApplication.Mode.TOPUP;
                plus.topupInfo = new TopupInfo(proto.getTopupInfo());
                break;
            case YPM_WITHDRAWAL:
                plus.mode = YandexPlusApplication.Mode.WITHDRAW;
                plus.withdrawalInfo = new WithdrawalInfo(proto.getWithdrawalInfo());
                break;
            default:
                throw new IllegalArgumentException("Unknown yandex plus mode: " + proto.getMode());
        }

        return plus;
    }

    @Getter
    public static class TopupInfo {
        private final int amount;
        private final EYandexPlusTopupState state;
        private final Instant topupDate;
        private final String purchaseToken;

        private TopupInfo(TTopupInfo proto) {
            this.amount = proto.getAmount();
            this.state = proto.getState();
            this.topupDate = ProtoUtils.toInstant(proto.getTopupDate());
            this.purchaseToken = proto.getPurchaseToken();
        }
    }

    @Getter
    public static class WithdrawalInfo {
        private final int amount;

        private WithdrawalInfo(TWithdrawalInfo proto) {
            this.amount = proto.getAmount();
        }
    }
}
