package ru.yandex.travel.api.models.avia;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;

@AllArgsConstructor
@Getter
@Builder(toBuilder = true)
@JsonDeserialize(builder = Passengers.PassengersBuilder.class)
public class Passengers {
    @NotNull
    private final Integer adults;
    @NotNull
    private final Integer children;
    @NotNull
    private final Integer infants;

    @JsonPOJOBuilder(withPrefix = "")
    public static class PassengersBuilder {
    }
}
