package ru.yandex.travel.api.models.avia;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@AllArgsConstructor
@Getter
public enum ServiceClass implements ValueBasedEnum<String> {
    ECONOMY("economy"), BUSINESS("business");

    private final String value;

    private static final EnumIndex<String,
            ServiceClass> BY_VALUE =
            EnumIndex.create(ServiceClass.class);

    @JsonCreator
    public static ServiceClass fromString(String value) {
        return BY_VALUE.getByValue(value);
    }

    @JsonValue
    public String toValue() {
        return value;
    }
}
