package ru.yandex.travel.api.models.avia.country_restrictions.v1;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@ApiModel(value = "Ограничения по странам - метрика")
@JsonIgnoreProperties(ignoreUnknown = true)
public class Metric {
    private JsonNode value;
    private RichString text;
    private List<RichString> additions;
    private List<RichString> exclusions;
    private String updatedTime;
    private String lastModificationTime;
    private ReturnPointInfo pointInfo;
}
