package ru.yandex.travel.api.models.common;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class ExtraVisitAndUserParams {
    /* NB! This structure is well-defined in API, but not in Spec.
       Frontend just passes visitParams and userParams as-is directly to metrika.
       Any new fields may be added to visitParams and userParams without changing Spec and Frontend.
     */

    @Data
    @NoArgsConstructor
    @JsonNaming(PropertyNamingStrategy.class) // This is required to preserve camelCase, and pass it to metrika
    public static class VisitParams {
        @Data
        @NoArgsConstructor
        @JsonNaming(PropertyNamingStrategy.class) // This is required to preserve camelCase, and pass it to metrika
        public static class Hotels {
            @JsonInclude(JsonInclude.Include.NON_NULL)
            private Map<String, String> hotelPage;

            @JsonInclude(JsonInclude.Include.NON_NULL)
            private Map<String, String> searchPage;

            @JsonInclude(JsonInclude.Include.NON_NULL)
            private Map<String, String> seoRegionPage;

            @JsonInclude(JsonInclude.Include.NON_NULL)
            private Map<String, String> bookingPage;
        }

        private Hotels hotels;
    }

    private VisitParams visitParams;

    // userParams currently not generated
}
