package ru.yandex.travel.api.models.common;

import lombok.Builder;
import lombok.Value;
import org.javamoney.moneta.Money;

import ru.yandex.travel.commons.proto.ProtoUtils;
import ru.yandex.travel.orders.workflow.invoice.proto.TMoneyMarkup;

@Value
@Builder
public class MoneyMarkup {
    private final Money card;
    private final Money yandexAccount;

    public static MoneyMarkup fromProto(TMoneyMarkup markup) {
        return MoneyMarkup.builder()
                .card(ProtoUtils.fromTPrice(markup.getCard()))
                .yandexAccount(ProtoUtils.fromTPrice(markup.getYandexAccount()))
                .build();
    }
}
