package ru.yandex.travel.api.models.common

import org.slf4j.LoggerFactory
import ru.yandex.travel.commons.proto.TPrice
import java.math.BigDecimal

data class Price(
    val value: String,
    val currency: Currency?,
) {

    enum class Currency {
        RUB, USD, EUR, JPY
    }

    companion object {
        val log = LoggerFactory.getLogger(Price::class.java)!!

        val ZERO = Price("0", null)

        fun fromProto(proto: TPrice?): Price? {
            if (proto == null || proto == proto.defaultInstanceForType) {
                return null
            }
            val currency = try {
                Currency.valueOf(proto.currency.name.substring(2))
            } catch (e: IllegalArgumentException) {
                log.warn("can't parse value {}", proto.currency, e)
                null
            }
            return Price(
                BigDecimal.valueOf(proto.amount, proto.precision).toString(),
                currency
            )
        }
    }
}
