package ru.yandex.travel.api.models.common;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.orders.commons.proto.EPromoCodeApplicationResultType;


@RequiredArgsConstructor
public enum PromoCodeApplicationResultType {
    UNKNOWN("UNKNOWN", EPromoCodeApplicationResultType.ART_UNKNOWN),
    SUCCESS("SUCCESS", EPromoCodeApplicationResultType.ART_SUCCESS),
    NOT_FOUND("NOT_FOUND", EPromoCodeApplicationResultType.ART_NOT_FOUND),
    NOT_APPLICABLE("NOT_APPLICABLE", EPromoCodeApplicationResultType.ART_NOT_APPLICABLE),
    ALREADY_APPLIED("ALREADY_APPLIED", EPromoCodeApplicationResultType.ART_ALREADY_APPLIED),
    EXPIRED("EXPIRED", EPromoCodeApplicationResultType.ART_EXPIRED),
    EMPTY_BUDGET("EMPTY_BUDGET", EPromoCodeApplicationResultType.ART_EMPTY_BUDGET),
    ;

    private final String value;

    private final EPromoCodeApplicationResultType protoValue;

    static ImmutableMap<EPromoCodeApplicationResultType, PromoCodeApplicationResultType> protoToEnum;

    static {
        ImmutableMap.Builder<EPromoCodeApplicationResultType, PromoCodeApplicationResultType> builder =
                new ImmutableMap.Builder<>();
        for (PromoCodeApplicationResultType v : PromoCodeApplicationResultType.values()) {
            builder.put(v.protoValue, v);
        }
        protoToEnum = builder.build();
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    public static PromoCodeApplicationResultType fromProto(EPromoCodeApplicationResultType protoValue) {
        PromoCodeApplicationResultType candidate = protoToEnum.get(protoValue);
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Don't know how to map proto value: %s", protoValue));
        }
        return candidate;
    }
}
