package ru.yandex.travel.api.models.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@AllArgsConstructor
@Getter
public enum TravelVertical implements ValueBasedEnum<String> {
    AVIA("avia"), HOTELS("hotels"), TRAINS("trains"), BUS("bus");

    private final String value;

    private static final EnumIndex<String, TravelVertical> BY_VALUE = EnumIndex.create(TravelVertical.class);

    @JsonCreator
    public static TravelVertical fromString(String value) {
        return BY_VALUE.getByValue(value);
    }
}
