package ru.yandex.travel.api.models.cpa;

import java.time.Instant;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.javamoney.moneta.Money;

@Data
public class BoyOrderSnapshotDto {

    private CpaOrderStatus orderStatus;
    private CpaOrderDisplayType displayType;
    private CpaItemState itemState;
    private String travelOrderId;
    private String boyOrderId;
    private String partnerOrderId;
    private String label;
    private Money amount;
    private Money profit;
    private List<String> promoCodes;
    private List<String> promoActions;
    private Money discountAmount;
    private boolean usesDeferredPayment;
    private Money amountReceivedFromUser;
    private boolean postPayEligible;
    private boolean postPayUsed;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "UTC")
    private Instant createdAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "UTC")
    private Instant updatedAt;
}
